/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.chat.ChatConstants;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.ChatScrollList;
import net.creeperhost.minetogether.chat.gui.FriendRequestScreen;
import net.creeperhost.minetogether.chat.gui.MutedUsersScreen;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.irc.IrcUser;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.polylib.gui.IconButton;
import net.creeperhost.minetogether.polylib.gui.SimpleSelectionList;
import net.creeperhost.minetogether.polylib.gui.TooltipContainer;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.StreamableIterable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;

public class FriendsListScreen
extends Screen {
    private final Screen parent;
    private SimpleSelectionList<FriendEntry> friendList;
    private EditBox searchBox;
    private ChatScrollList chatList;
    private EditBox chatBox;
    @Nullable
    private Profile targetProfile;
    private Button removeFriend;
    private Button blockButton;
    private Button partyButton;
    private Button editButton;
    private Button acceptRequest;
    private Button denyRequest;
    private TooltipContainer tooltips;
    private int ticks;
    private int lastFriendUpdateCookie = -1;

    public FriendsListScreen(Screen parent) {
        super((Component)new TranslatableComponent("minetogether:screen.friends.title"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.lastFriendUpdateCookie = -1;
        this.friendList = new SimpleSelectionList(this.f_96541_, 100, this.f_96544_ - 90, 32, this.f_96544_ - 55, 28, 100);
        this.friendList.m_93507_(18);
        this.m_142416_((GuiEventListener)this.friendList);
        this.chatList = new ChatScrollList(Minecraft.m_91087_(), this.f_96543_ - this.friendList.m_5759_() - 40, this.f_96544_ - 90, 32, this.f_96544_ - 55);
        this.chatList.m_93507_(this.friendList.m_93520_());
        this.chatList.m_93410_(this.chatList.m_93518_());
        this.m_142416_((GuiEventListener)this.chatList);
        this.chatBox = new EditBox(this.f_96547_, this.friendList.m_93520_() + 1, this.f_96544_ - 50, this.chatList.width - 2, 20, TextComponent.f_131282_);
        this.chatBox.m_94199_(256);
        this.m_142416_((GuiEventListener)this.chatBox);
        this.searchBox = new EditBox(this.f_96547_, 19, this.f_96544_ - 50, this.friendList.getWidth() - 2, 20, TextComponent.f_131282_);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.m_142416_((GuiEventListener)new Button(5, this.f_96544_ - 26, 100, 20, (Component)new TranslatableComponent("minetogether:button.cancel"), e -> this.f_96541_.m_91152_(this.parent)));
        this.acceptRequest = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 215, this.f_96544_ - 26, 100, 20, (Component)new TranslatableComponent("minetogether:screen.friends.button.accept"), e -> {
            FriendEntry entry = (FriendEntry)this.friendList.m_93511_();
            assert (entry != null);
            assert (entry.request != null);
            Minecraft.m_91087_().m_91152_((Screen)new FriendRequestScreen(this, entry.request));
        }));
        this.acceptRequest.f_93624_ = false;
        this.denyRequest = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 110, this.f_96544_ - 26, 100, 20, (Component)new TranslatableComponent("minetogether:screen.friends.button.deny"), e -> {
            FriendEntry entry = (FriendEntry)this.friendList.m_93511_();
            assert (entry != null);
            assert (entry.request != null);
            MineTogetherChat.CHAT_STATE.profileManager.denyFriendRequest(entry.request);
            this.updateList();
        }));
        this.denyRequest.f_93624_ = false;
        this.removeFriend = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ - 20, 32, 5, Constants.WIDGETS_SHEET, e -> {
            assert (this.targetProfile != null);
            this.chatList.attach(null);
            MineTogetherChat.CHAT_STATE.profileManager.removeFriend(this.targetProfile);
        }));
        this.blockButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ - 20, 52, 6, Constants.WIDGETS_SHEET, e -> {
            assert (this.targetProfile != null);
            this.targetProfile.mute();
        }));
        this.partyButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ - 20, 72, 7, Constants.WIDGETS_SHEET, e -> {}));
        this.partyButton.f_93623_ = false;
        this.editButton = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_96543_ - 20, 92, 8, Constants.WIDGETS_SHEET, e -> {
            assert (this.targetProfile != null);
            Minecraft.m_91087_().m_91152_((Screen)new FriendRequestScreen(this, this.targetProfile, FriendRequestScreen.Type.UPDATE));
        }));
        if (!(this.parent instanceof MutedUsersScreen)) {
            this.m_142416_((GuiEventListener)new Button(5, 5, 100, 20, (Component)new TranslatableComponent("minetogether:screen.friends.button.muted"), e -> this.f_96541_.m_91152_((Screen)new MutedUsersScreen(this))));
        }
        this.tooltips = new TooltipContainer(this);
        this.m_169394_(this.tooltips);
        this.tooltips.addTooltip(this.removeFriend, (Component)new TranslatableComponent("minetogether:screen.friends.tooltip.remove"));
        this.tooltips.addTooltip(this.blockButton, (Component)new TranslatableComponent("minetogether:screen.friends.tooltip.block"));
        this.tooltips.addTooltip(this.partyButton, (Component)new TranslatableComponent("minetogether:screen.friends.tooltip.party"));
        this.tooltips.addTooltip(this.editButton, (Component)new TranslatableComponent("minetogether:screen.friends.tooltip.edit"));
        this.updateList();
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.m_96626_(1);
        super.m_6305_(poseStack, i, j, f);
    }

    public void m_96624_() {
        ++this.ticks;
        this.updateList();
        FriendEntry selected = (FriendEntry)this.friendList.m_93511_();
        IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
        if (selected != null && state == IrcState.CONNECTED) {
            this.targetProfile = selected.profile;
            this.acceptRequest.f_93624_ = selected.request != null;
            this.denyRequest.f_93624_ = selected.request != null;
            IrcUser user = MineTogetherChat.CHAT_STATE.ircClient.getUser(selected.profile);
            if (user != null) {
                this.chatList.attach(user.getChannel());
                this.chatBox.m_94186_(true);
                this.chatBox.m_94167_("");
            } else {
                this.chatList.attach(null);
                this.chatBox.m_94186_(false);
                this.chatBox.m_94167_("User is offline.");
            }
        } else {
            this.targetProfile = null;
            this.chatList.attach(null);
            this.chatBox.m_94186_(false);
            if (state == IrcState.CONNECTED) {
                this.chatBox.m_94167_("Select a friend.");
            } else {
                this.chatBox.m_94167_(ChatConstants.STATE_DESC_LOOKUP.get((Object)state));
            }
        }
        this.removeFriend.f_93623_ = this.targetProfile != null;
        this.blockButton.f_93623_ = this.targetProfile != null;
        this.editButton.f_93623_ = this.targetProfile != null;
    }

    public boolean m_5534_(char c, int i) {
        if (this.searchBox.m_93696_()) {
            this.updateList();
        }
        if (this.chatBox.m_93696_()) {
            return this.chatBox.m_5534_(c, i);
        }
        return super.m_5534_(c, i);
    }

    public boolean m_7933_(int i, int j, int k) {
        if (this.searchBox.m_93696_()) {
            this.updateList();
        }
        if (this.targetProfile != null && this.chatBox.m_93696_()) {
            String str = this.chatBox.m_94155_().trim();
            if (!(i != 257 && i != 335 || str.isEmpty())) {
                this.chatList.getChannel().sendMessage(str);
                this.chatBox.m_94144_("");
            }
        }
        return super.m_7933_(i, j, k);
    }

    private void updateList() {
        FriendEntry friendEntry;
        ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
        int newCookie = profileManager.getFriendUpdateCookie();
        if (this.lastFriendUpdateCookie == newCookie) {
            return;
        }
        this.lastFriendUpdateCookie = newCookie;
        List<Profile> knownUsers = profileManager.getKnownProfiles();
        LinkedList<Profile> friends = StreamableIterable.of(knownUsers).filter(Profile::isFriend).toLinkedList();
        friends.sort(NameComparator.INSTANCE);
        friends.sort(Comparator.comparingInt(e -> e.isOnline() ? 1 : 0));
        this.friendList.m_93516_();
        String search = this.searchBox.m_94155_();
        for (Profile friend : friends) {
            if (!search.isEmpty() && !friend.getFriendName().toLowerCase().contains(search.toLowerCase())) continue;
            friendEntry = new FriendEntry(this.friendList, friend);
            this.friendList.m_7085_(friendEntry);
        }
        for (ProfileManager.FriendRequest request : profileManager.getFriendRequests()) {
            if (!search.isEmpty() && !request.from.getDisplayName().toLowerCase().contains(search.toLowerCase())) continue;
            friendEntry = new FriendEntry(this.friendList, request);
            this.friendList.m_7085_(friendEntry);
        }
        for (FriendEntry entry : this.friendList.m_6702_()) {
            if (entry.profile != this.targetProfile) continue;
            this.friendList.m_6987_(entry);
            break;
        }
    }

    private static class FriendEntry
    extends SimpleSelectionList.SimpleEntry<FriendEntry> {
        @Nullable
        private final ProfileManager.FriendRequest request;
        private final Profile profile;

        public FriendEntry(SimpleSelectionList<FriendEntry> list, ProfileManager.FriendRequest request) {
            this(list, request, request.from);
        }

        public FriendEntry(SimpleSelectionList<FriendEntry> list, Profile profile) {
            this(list, null, profile);
        }

        public FriendEntry(SimpleSelectionList<FriendEntry> list, @Nullable ProfileManager.FriendRequest request, Profile profile) {
            super(list);
            this.request = request;
            this.profile = profile;
        }

        @Override
        public void m_6311_(PoseStack poseStack, int idx, int top, int left, int width, int height, int mx, int my, boolean hovered, float partialTicks) {
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            Object name = this.profile.isFriend() ? this.profile.getFriendName() : this.profile.getDisplayName();
            boolean ellipsis = false;
            while (font.m_92895_((String)name) >= width - 15) {
                name = ((String)name).substring(0, ((String)name).length() - 1);
                ellipsis = true;
            }
            if (ellipsis) {
                name = (String)name + "...";
            }
            font.m_92883_(poseStack, (String)name, (float)(left + 5), (float)(top + 4), 0xFFFFFF);
            TextComponent component = new TextComponent((String)(this.profile.isFriend() ? (this.profile.isOnline() ? ChatFormatting.DARK_GREEN + "Online" : "Offline") : "Pending"));
            font.m_92889_(poseStack, (Component)component, (float)(left + 5), (float)(top + 15), 0xFFFFFF);
        }
    }

    public static class NameComparator
    implements Comparator<Profile> {
        public static final NameComparator INSTANCE = new NameComparator();

        @Override
        public int compare(Profile profile1, Profile profile2) {
            String str2;
            String str1 = profile1.getFriendName();
            int res = String.CASE_INSENSITIVE_ORDER.compare(str1, str2 = profile2.getFriendName());
            if (res == 0) {
                res = str1.compareTo(str2);
            }
            return res;
        }
    }
}

